% The FDC toolbox - Model definitions, analytical tools, etc.
% ===========================================================
% The directory TOOLS contains some Matlab routines to load or specify
% model parameters, a program to find steady-state trimmed flight conditions,
% a linearization program, a Matlab macro for post-processing simulation
% results from the non-linear aircraft model, and a Simulink block-library
% containing some useful general-purpose blocks. The following files are
% included:
%
% ACCONSTR.M   Matlab subroutine which is called by the trim program ACTRIM
%              and its subroutine ACCOST. This routine evaluates the flight-
%              path constraints during the trimming process.
%
% ACCOST.M     Matlab subroutine which is called by the trim program ACTRIM.
%              This routine evaluates the cost function during the trimming
%              process.
%
% ACLIN.M      Matlab program for linearizing the non-linear aircraft model,
%              using the Simulink linearization routine LINMOD. ACLIN con-
%              tains many options for defining linearized aircraft models,
%              based upon the definitions of states and inputs from the sys-
%              tem BEAVER. ACLIN also is powerful with regard to the presen-
%              tation of the results from the linearization process.
%
% ACTRIM.M     Matlab program for determining steady-state trimmed flight-
%              conditions for the non-linear aircraft model BEAVER (or any
%              other model which uses the same inputs and outputs). This
%              routine takes into account flight-path constraints. It is
%              quite flexible with regard to the initial definitions of the
%              flight condition and the presentation of the results from the
%              trimming process.
%
% BROWSE.M     Matlab function, used to display on-line help texts for FDC.
%
% DATADIR.M    Matlab function which determines the default-directory where
%              the other FDC routines will search for datafiles (subdirectory
%              DATA).
%
% DATLOAD.M    Matlab program which can be used to load model parameters from
%              file (*.DAT files), such as the aircraft-model parameters from
%              AIRCRAFT.DAT. This program is called by other routines if they 
%              are unable to find the model-parameters in the Matlab workspace
%              when they need them. In addition, DATLOAD can be used as stand-
%              alone program too.
%
% FDCDIR.M     Matlab function, used to select an FDC subdirectory as default
%              directory.
%
% FDCINIT.M    The initialization routine for the FDC toolbox, which is used
%              to manage the FDC subdirectories and add them to the Matlab path
%              for the initialization of the toolbox
%
% FDCINIT.INI  This file contains the current default initialization for the 
%              FDC toolbox. It is read-out by FDCINIT.M and by some other 
%              routines to extract default path-settings. As this file is
%              created by FDCINIT.M, it will not exist until that routine has
%              been run at least once.
%
% FDCLOAD.M    Matlab function that loads user-specified FDC datafile(s) via 
%              the UIGETFILE GUI. This function is called by the routines
%              DATLOAD.M, LINLOAD.M, MATLOAD.M, and TRILOAD.M, but it can also
%              be used as stand-alone utility.
%
% FDCTOOLS.MDL Simulink block-library with some useful general-purpose blocks
%              which can't be found in the standard Simulink libraries.
%
% FIXSTATE.M   Matlab program which can be used for artificially fixing
%              state  variables from the aircraft model to their initial
%              values during simulations. For instance, decoupling symmetrical
%              and asymmetrical motions of the aircraft may sometimes be
%              useful, especially for demonstrations of the basic aircraft
%              responses (i.e. its eigenfrequencies, etc.).
%
% HELPDIR.M    Matlab function which determines the default-directory of the
%              FDC help-texts (subdirectory HELP).
%
% LINLOAD.M    Matlab program which is used to load linear dynamic models 
%              from file (*.LIN files). 
%
% MATLOAD.M    Matlab program which can be used to load *.MAT files.
%
% NUM2STR2.M   Slightly changed version of NUM2STR. Makes it possible to
%              specify the number of string elements to be used. This routine
%              is called by the trim and linearization routines ACTRIM and
%              ACLIN and the Matlab function SYSTPROP.
%
% NEWMSGBOX.M  Matlab function which provides an alternative for MSGBOX. This
%              function is used by several routines from the FDC toolbox to 
%              display short messages in a dialog window (it is somewhat 
%              easier on the eyes than MSGBOX itself)
%
% RESPLOT.M    Plotting routine with as yet VERY limited capabilities. Still
%              it may be useful to run this program after running RESULTS
%              for viewing the most important simulation results from the
%              non-linear aircraft model. Expect better versions in the
%              future...
%
% RESULTS.M    Matlab macro for post-processing results of simulations of the
%              non-linear aircraft model. This routine is not very flexible:
%              it only works well for systems which use exactly the same
%              input and output vectors as the system BEAVER. However, it is
%              very easy to modify this routine when necessary.
%
% SETDIR.M     Matlab function which asks the user to specify a directory
%              name and then checks whether this directory actually exists.
%              It is called by a number of other FDC programs.
%
% SOFTLIM.M    Matlab function, called by the Simulink block 'Soft-limiter'
%              from the block-library FDCTOOLS.
%
% SYSTPROP.M   Matlab function, computes some basic properties of linear
%              systems in state-space or transfer function format.
%
% TRILOAD.M    Matlab program which is used to load trimmed-flight operating
%              points from file (*.TRI files). It is called by ACLIN, but it
%              can also be used as stand-alone program.

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------